// SocketNativeClientDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SocketNativeClient.h"
#include "SocketNativeClientDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSocketNativeClientDlg dialog




CSocketNativeClientDlg::CSocketNativeClientDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSocketNativeClientDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSocketNativeClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO1, comboPort);
	DDX_Control(pDX, IDC_COMBO2, comboTypGniazda);
	DDX_Control(pDX, IDC_EDIT1, edit1);
	DDX_Control(pDX, IDC_IPADDRESS1, addr);
}

BEGIN_MESSAGE_MAP(CSocketNativeClientDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON2, &CSocketNativeClientDlg::OnBnClickedButton2)
END_MESSAGE_MAP()


// CSocketNativeClientDlg message handlers

BOOL CSocketNativeClientDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	CString gniazdo;
	for(int i=1025;i<5000;i++)
	{
		gniazdo.AppendFormat(L"%d",i);
		comboPort.AddString(gniazdo);
		gniazdo.Empty();
	}

	comboTypGniazda.AddString(L"poczeniowy");
	comboTypGniazda.AddString(L"bezpoczeniowy");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSocketNativeClientDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSocketNativeClientDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CSocketNativeClientDlg::OnBnClickedButton2()
{
	addr.EnableWindow(false);
	comboPort.EnableWindow(false);
	comboTypGniazda.EnableWindow(false);

	int port, typGniazda, protokol;
	
	CString szPort;
	comboPort.GetWindowTextW(szPort);
	port = _wtoi(szPort);

	CString strAddr;
    addr.GetWindowTextW(strAddr);
	
	char szAddr[16] = {'\0'};
	wcstombs(szAddr,strAddr,16);

	CString tekst;
	edit1.GetWindowTextW(tekst);
	char dane [1024] = {'\0'};
	wcstombs(dane,tekst,1024);
	
	switch(comboTypGniazda.GetCurSel())
	{
	case 1:
		typGniazda =  SOCK_DGRAM;
		klientUDP.ZainicjujWinsock(typGniazda);
		klientUDP.Wyslij(szAddr,port,dane,sizeof(dane));
		klientUDP.ZamknijGniazdo();
		break;
	case 0:
	default:
		typGniazda = SOCK_STREAM;
		klientTCP.ZainicjujWinsock(typGniazda);
		klientTCP.Wyslij(szAddr,port,dane,sizeof(dane));
		klientUDP.ZamknijGniazdo();
		break;
	}

	addr.EnableWindow(true);
	comboPort.EnableWindow(true);
	comboTypGniazda.EnableWindow(true);
}
